% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrMethod.R
\name{summary.cdfqr}
\alias{summary.cdfqr}
\alias{print.cdfqr}
\alias{logLik.cdfqr}
\alias{nobs.cdfqr}
\alias{deviance.cdfqr}
\alias{coef.cdfqr}
\alias{vcov.cdfqr}
\alias{update.cdfqr}
\alias{formula.cdfqr}
\alias{confint.cdfqr}
\title{S3 Methods for getting output from fitted cdfqr Objects.}
\usage{
\method{summary}{cdfqr}(object, ...)

\method{print}{cdfqr}(x, digits = max(3, getOption("digits") - 3), ...)

\method{logLik}{cdfqr}(object, ...)

\method{nobs}{cdfqr}(object, ...)

\method{deviance}{cdfqr}(object, ...)

\method{coef}{cdfqr}(object, type = c("full", "mean", "sigma"), ...)

\method{vcov}{cdfqr}(object, type = c("full", "mean", "sigma"), ...)

\method{update}{cdfqr}(object, formula., ..., evaluate = TRUE)

\method{formula}{cdfqr}(x, ...)

\method{confint}{cdfqr}(object, parm, level = 0.95, submodel = "full", ...)
}
\arguments{
\item{object}{The fitted cdfqr model.}

\item{...}{Pass onto other functions or currently ignored}

\item{x}{The fitted cdfqr model.}

\item{digits}{Number of digits to be retained in printed output.}

\item{type, submodel}{The parts of coefficients or variance-covariance matrix to be extracted.Can be "full", "mean",or "sigma".}

\item{formula.}{Changes to the formula. See \code{\link[Formula]{update.Formula}} for details.}

\item{evaluate}{If true evaluate the new updated model else return the call for the new model.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}
}
\description{
Give the S3 Methods for CDF-Quantile Distribution Models
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)

summary(fit)
print(fit)
logLik(fit)
coef(fit)
deviance(fit)
vcov(fit)
confint(fit)

#Update the model
fit2 <- update(fit, crc99 ~ vert*confl | confl)
summary(fit2)

}
