% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdgd0_ml.R
\name{cdgd0_ml}
\alias{cdgd0_ml}
\title{Perform unconditional decomposition via machine learning}
\usage{
cdgd0_ml(Y, D, G, X, data, algorithm, alpha = 0.05, trim = 0)
}
\arguments{
\item{Y}{Outcome. The name of a numeric variable (can be binary and take values of 0 and 1).}

\item{D}{Treatment status. The name of a binary numeric variable taking values of 0 and 1.}

\item{G}{Advantaged group membership. The name of a binary numeric variable taking values of 0 and 1.}

\item{X}{Confounders. A vector of variables names.}

\item{data}{A data frame.}

\item{algorithm}{The ML algorithm for modelling. "nnet" for neural network, "ranger" for random forests, "gbm" for generalized boosted models.}

\item{alpha}{1-alpha confidence interval.}

\item{trim}{Threshold for trimming the propensity score. When trim=a, individuals with propensity scores lower than a or higher than 1-a will be dropped.}
}
\value{
A list of estimates.
}
\description{
Perform unconditional decomposition via machine learning
}
\examples{
# This example will take a minute to run.
\donttest{
data(exp_data)

set.seed(1)

results <- cdgd0_ml(
Y="outcome",
D="treatment",
G="group_a",
X=c("Q","confounder"),
data=exp_data,
algorithm="gbm")

results[[1]]}
}
