% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wg2ws_category_score.R
\name{wg2ws_category_score}
\alias{wg2ws_category_score}
\title{Simulate WS category score from given WG score}
\usage{
wg2ws_category_score(wg_table, age = NA, WG_total = NA, verbose = FALSE)
}
\arguments{
\item{wg_table}{A 22-row table with the columns \code{category} and \code{n}. Includes
Sounds and Connecting Words.}

\item{age}{(Optional). Age in months. If unset, models not including age
are used}

\item{WG_total}{NA/numeric:
In the case of \verb{in/inside}, the WG score model can be
off-by-one. Out of so many items, this is negligible, but
can be set explicitly here.}

\item{verbose}{T/F: Be verbose.}
}
\value{
New scores (data frame of 22 scores)
}
\description{
Take 22 WG scores and simulates WS scores for each one.
}
\details{
This function predicts simulated WS scores for each category score
independently. If an age is not supplied, models not using age are used
(less accurate than including age).
}
\examples{
# Create list of words a child knows
words <- c("smile", "old", "chicken (animal)", "breakfast", "snow", "uh oh",
           "please", "bad", "bicycle", "moon")

# Create table
wg_categories <- wg2ws_items(words)

# Convert to WS score
ws_categories <- wg2ws_category_score(wg_categories, age = 20)
}
