% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDRC.R
\name{getCDRC}
\alias{getCDRC}
\title{Get data from the CDRC}
\usage{
getCDRC(
  dataCode,
  geography = c("postcode", "MSOA", "LSOA", "LAD", "LADname"),
  geographyCode,
  boundaries = FALSE
)
}
\arguments{
\item{dataCode}{A character-string API identifier associated which each dataset in the CDRC. To find out the dataCode of your desired dataset run \code{listCDRC()}.}

\item{geography}{The geographical levels in which the data can be retrieved. It can be postcode, MSOA, LSOA, LAD or LADname.
Note that the geography in which the data are retrieved does not necessarily correspond with the geography of the data. For example, it is possible to query data of the AHAH index by postcodes although the index is originally at LSOA level. Therefore you will see returned the LSOAs that better match the required postcodes.}

\item{geographyCode}{A character-vector of one or more postcodes, LSOA codes, MSOA codes, LAD codes or LAD names.}

\item{boundaries}{if FALSE (the default), returns a data frame of the desired data. if TRUE, uses the Open Geography Portal API to return an sf with the 'geometry' column.}
}
\value{
A dataframe or sf depending whether boundaries are set to FALSE or TRUE respectively.
}
\description{
Obtain data from the CDRC datasets. To find out what datasets are available and their respective dataCode run \code{listCDRC()}.
}
\examples{
\dontrun{
ahah_data <- getCDRC("AHAHOverallIndexDomain",geography = "postcode",
geographyCode = c("CH430UQ","LS61EF","L83UL"), boundaries = TRUE)
View(ahah_data)
plot(ahah_data$geometry)
}
}
