% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simpca.R
\name{simpca}
\alias{simpca}
\title{Simulate Data with a Specific Principal Components Structure and Response
Style Contamination}
\usage{
simpca(nr.indv = rep(200, 5), m = 10, q = 7, R = rcormat(m = m),
  err.coeff = 0.1, alphamat = rbind(c(0.5, 2, 4), c(10, 2, 10), c(1, 2, 1),
  c(4, 2, 0.5), c(0.1, 2, 0.1))[1:length(nr.indv), ], randomize = FALSE)
}
\arguments{
\item{nr.indv}{Numeric vector of group sizes.}

\item{m}{Integer; then number of variables to simulate.}

\item{q}{Integer; the rating scale used \code{1:q}.}

\item{R}{List with entry named 'R' which is the simulated correlation matrix}

\item{err.coeff}{Standard error for each variable, added unto \code{R}.}

\item{alphamat}{Matrix containing splines coefficients for te construction
of respone styles.}

\item{randomize}{logical; should the rows of the data be randomly permuted
or not?}
}
\description{
Simulate normally distributed data with specific covariance structure and
randomly sampled means. Adds response style contamination.
}

