% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree-mboost.R
\name{survival_time_mboost}
\alias{survival_time_mboost}
\title{A wrapper for mean survival times with \code{mboost} models}
\usage{
survival_time_mboost(object, new_data)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from \link[parsnip:details_boost_tree_mboost]{boost_tree() with engine = "mboost"}.}

\item{new_data}{Data for prediction}
}
\value{
A tibble.
}
\description{
A wrapper for mean survival times with \code{mboost} models
}
\examples{
\dontshow{if (rlang::is_installed("mboost")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
boosted_tree <- boost_tree() \%>\%
  set_engine("mboost") \%>\%
  set_mode("censored regression") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = lung[-14, ])
survival_time_mboost(boosted_tree, new_data = lung[1:3, ])
\dontshow{\}) # examplesIf}
}
\keyword{internal}
