% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxy_geocode.R
\name{cxy_geocode}
\alias{cxy_geocode}
\title{Geocode Addresses Using the Census Bureau Geocoder}
\usage{
cxy_geocode(.data, address, city, state, zip,
    style = "minimal", output = "tibble", timeout = 30)
}
\arguments{
\item{.data}{Data frame or tibble containing address data}

\item{address}{Column name containing address}

\item{city}{Optional; column name containing city}

\item{state}{Optional; column name containing state}

\item{zip}{Optional; column name containing 5-digit zip code}

\item{style}{One of either \code{"minimal"} or \code{"full"}}

\item{output}{One of either \code{"tibble"} or \code{"sf"}}

\item{timeout}{Maximum number of minutes for each API call to the geocoder.}
}
\value{
Either a tibble or sf object containing the census geocoder response.
}
\description{
This is the single function of the censusxy package, allowing
    for the easy geocoding of US Addresses using the US Census Bureau
    Geocoder. This function allows for flexible input and virtually
    unlimited batch sizes. See the vignette \code{vignette(censusxy)}
    for more details
}
\examples{
\donttest{
# load sample data
data <- stl_homicides_small

# geocode data
data <- cxy_geocode(data, address = "street_address", city = "city",
    state = "state", zip = "postal_code")

# preview data
data
}

}
