% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single.R
\name{cxy_oneline}
\alias{cxy_oneline}
\title{Geocode Single One Line Address}
\usage{
cxy_oneline(
  address,
  return = "locations",
  benchmark = "Public_AR_Current",
  vintage = NULL
)
}
\arguments{
\item{address}{String containing a single line address}

\item{return}{One of 'locations' or 'geographies' See Details.}

\item{benchmark}{Optional ID or Name of Census Benchmark. See Details.}

\item{vintage}{Optional ID or Name of Census Vintage. See Details.}
}
\value{
A data.frame containing matched address or NULL if not matches
}
\description{
Provides access to the oneline single address geocoding API from the US Census Bureau.
  This can be used with an address that is not parsed.
}
\details{
To obtain current valid benchmarks, use the \code{cxy_benchmarks()} function.

If you want to append census geographies, you must specify a valid vintage for your benchmark.
    You may use the \code{cxy_vintages()} function to obtain valid Vintages. See \code{vignette('censusxy')}
    for a full walkthrough.
}
\examples{
\donttest{
cxy_oneline(address = "20 N Grand Blvd, St Louis, MO 63108", return = "locations")
}

}
