% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_skeleton.R
\name{cnt_skeleton}
\alias{cnt_skeleton}
\title{Create a skeleton of a closed polygon object}
\usage{
cnt_skeleton(input, keep = 0.5)
}
\arguments{
\item{input}{\code{sf}, \code{sfc}, \code{SpatVector}, or
\code{geos_geometry} polygons object}

\item{keep}{numeric, proportion of points to retain (0.05-Inf; default 0.5).
See Details.}
}
\value{
a \code{sf}, \code{sfc}, \code{SpatVector}
or \code{geos_geometry} class object of a \code{MULTILINESTRING} geometry
}
\description{
This function generates skeletons (centerlines) of closed polygon objects
by applying Voronoi diagrams (Voronoi, 1908).
A Voronoi diagram partitions space into regions based on the distance to
the polygon's vertices. The edges of these
cells form a network of lines (skeletons) that represent
the structure of the polygon while preserving its overall shape.
}
\details{
\itemize{
\item If \code{keep} equals 1, no transformation will occur. The
function will use the original geometry to find the skeleton.
\item If the \code{keep} parameter is below 1, then the \code{\link[geos:geos_centroid]{geos::geos_simplify()}}
function will be used. So the original input
geometry would be simplified, and the resulting skeleton will be cleaner but
maybe more edgy.
The current realisation of simplification is similar (\emph{but not identical})
to \code{rmapshaper::ms_simplify()} one with Douglas-Peuker algorithm. However,
due to \code{geos} superpower, it performs several times faster.
If you find that the built-in simplification algorithm performs poorly,
try \code{rmapshaper::ms_simplify()} first and then find the polygon skeleton
with \code{keep = 1}, i.e.
\code{cnt_skeleton(rmapshaper::ms_simplify(polygon_sf), keep = 1)}
\item If the \code{keep} is above 1, then the densification
algorithm is applied using the \code{\link[geos:geos_centroid]{geos::geos_densify()}} function. This may
produce a very large object if keep is set more than 2. However, the
resulting skeleton would potentially be more accurate.
}
}
\examples{
library(sf)

polygon <-
  sf::st_read(system.file("extdata/example.gpkg", package = "centerline"),
    layer = "polygon",
    quiet = TRUE
  )

plot(polygon)

pol_skeleton <- cnt_skeleton(polygon)

plot(pol_skeleton)
}
\references{
Voronoi, G. (1908). Nouvelles applications des paramètres
continus à la théorie des formes quadratiques. Journal für die reine und
angewandte Mathematik, 134, 198-287. \doi{10.1515/crll.1908.134.198}
}
