% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codebook.R
\name{create_codebook}
\alias{create_codebook}
\title{Create a Codebook for Canadian Election Study Dataset}
\usage{
create_codebook(data, include_values = TRUE, format = "tibble")
}
\arguments{
\item{data}{A CES dataset, typically retrieved using \code{get_ces()}.}

\item{include_values}{Logical indicating whether to include response values
in addition to labels. Default is TRUE.}

\item{format}{A character string indicating the format to return the codebook in.
Default is "tibble". Options include "tibble" or "data.frame".}
}
\value{
A tibble or data.frame containing the codebook with columns for
variable name, question label, and response options.
}
\description{
This function generates a comprehensive codebook for a CES dataset, including
variable names, question labels, and response options.
}
\examples{
\donttest{
# Get the 2019 CES data
ces_2019 <- get_ces("2019")

# Create a codebook
codebook <- create_codebook(ces_2019)

# View the first few entries
head(codebook)

# Create a codebook without values
codebook_simple <- create_codebook(ces_2019, include_values = FALSE)
}

}
