% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceteris_paribus.R
\name{ceteris_paribus}
\alias{ceteris_paribus}
\title{Ceteris Paribus Explainer}
\usage{
ceteris_paribus(
  explainer,
  observations,
  y = NULL,
  variable_splits = NULL,
  variables = NULL,
  grid_points = 101
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by function `DALEX::explain()`.}

\item{observations}{set of observarvation for which profiles are to be calculated}

\item{y}{true labels for `observations`. If specified then will be added to ceteris paribus plots.}

\item{variable_splits}{named list of splits for variables, in most cases created with `calculate_variable_splits()`. If NULL then it will be calculated based on validation data avaliable in the `explainer`.}

\item{variables}{names of variables for which profiles shall be calculated. Will be passed to `calculate_variable_splits()`. If NULL then all variables from the validation data will be used.}

\item{grid_points}{number of points for profile. Will be passed to `calculate_variable_splits()`.}
}
\value{
An object of the class 'ceteris_paribus_explainer'.
It's a data frame with calculated average responses.
}
\description{
This function calculate ceteris paribus profiles for selected data points.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

apartments_small <- select_sample(apartmentsTest, 10)

cp_rf <- ceteris_paribus(explainer_rf, apartments_small)
cp_rf

cp_rf <- ceteris_paribus(explainer_rf, apartments_small, y = apartments_small$m2.price)
cp_rf
}
}
