% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifiable.R
\name{identifiable}
\alias{identifiable}
\title{Identify a Counterfactual Query}
\usage{
identifiable(
  g,
  gamma,
  delta = NULL,
  data = c("interventions", "observations", "both")
)
}
\arguments{
\item{g}{A \code{dag} object describing the causal graph
(to obtain a \code{dag} from another format, see \code{\link[=import_graph]{import_graph()}}.}

\item{gamma}{An \R object that can be coerced into a
\code{counterfactual_conjunction} object that represents the
counterfactual causal query.}

\item{delta}{An \R object that can be coerced into a
\code{counterfactual_conjunction} object that represents the conditioning
conjunction (optional).}

\item{data}{A \code{character} string that accepts one of the following:
\code{"interventions"} (the default), \code{"observations"}or \code{"both"}. This argument
defines the target level of identification. If \code{"interventions"} is used,
the identification is attempted down to the intervention level. If
\code{"observations"} is used, identification is attempted down to the
observational level. If \code{"both"} is used, identification is carried out
for each term to the lowest level where the term is still identifiable.}
}
\value{
An object of class \code{query} which is a \code{list} containing
one or more of the following:
\itemize{
\item \code{id}\cr A \code{logical} value that is \code{TRUE} if the query is identifiable and
\code{FALSE} otherwise from the available \code{data} in \code{g}.
Note that in cases where \code{gamma} itself is
inconsistent, the query will be identifiable, but with probability 0.
\item \code{formula}\cr An object of class \code{functional} giving the identifying
functional of the query in LaTeX syntax via \code{format} or \code{print},
if identifiable. This expression is given in terms of the
available \code{data}. Variables bound by summation are distinguished by a
superscript asterisk. For tautological statements, the resulting
probability is 1, and for inconsistent statements, the resulting
probability is 0. For formatting options, see
\code{\link[=format.functional]{format.functional()}} and \code{\link[=format.probability]{format.probability()}}.
\item \code{undefined}\cr A logical value that is \code{TRUE} if
a conditional conjunction \eqn{p(\gamma|\delta)} is undefined,
for example when \eqn{p(\delta) = 0}, and \code{FALSE} otherwise.
\item \code{gamma}\cr The original counterfactual conjunction..
\item \code{delta}\cr The original conditioning counterfactual conjunction.
\item \code{data}\cr The original data.
}
}
\description{
Determine the identifiability of a (conditional) counterfactual conjunction.
}
\details{
To identify a non-conditional conjunction \eqn{P(\gamma)}, the argument
\code{delta} should be \code{NULL}.

To identify a conditional conjunction \eqn{P(\gamma|\delta)}, both \code{gamma}
and \code{delta} should be specified.

First, a parallel worlds graph is constructed based on the query. In a
parallel worlds graph, for each \eqn{do}-action that appears in \eqn{\gamma}
(and \eqn{\delta}) a copy of the original graph is created with the new
observational variables attaining their post-interventional values
but sharing the latent variables. This graph is known as a parallel worlds
graph. From the parallel worlds graph, a counterfactual graph
is derived such that each variable is unique, which might not be the case
in a parallel worlds graph.

Finally, the ID* (or IDC*) algorithm is applied to determine identifiability
of the query. Similar to the ID and IDC algorithms for causal effects,
these algorithms exploit the so called c-component factorization to split
the query into smaller subproblems, which are then solved recursively.
If argument \code{data} is \code{"observations"} or \code{"both"}, identification of
interventional probabilities in the resulting functional is further
attempted in terms of the joint probability distribution by using the
ID and IDC algorithms (see \link{causal_effect}).
}
\examples{
# Examples that appears in Shpitser and Pearl (2008)
g1 <- dag("X -> W -> Y <- Z <- D X <-> Y")
g2 <- dag("X -> W -> Y <- Z <- D X <-> Y X -> Y")
v1 <- cf("Y", 0, c(X = 0))
v2 <- cf("X", 1)
v3 <- cf("Z", 0, c(D = 0))
v4 <- cf("D", 0)
c1 <- conj(v1)
c2 <- conj(v2, v3, v4)
c3 <- conj(v1, v2, v3, v4)

# Identifiable conditional conjunction
identifiable(g1, c1, c2)

# Identifiable conjunction
identifiable(g1, c3)

# Non-identifiable conjunction
identifiable(g2, c3)

}
\seealso{
\code{\link[=dag]{dag()}}, \code{\link[=counterfactual_variable]{counterfactual_variable()}},
\code{\link[=probability]{probability()}}, \code{\link[=functional]{functional()}}
}
