% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_constraints.R
\name{build_constraints}
\alias{build_constraints}
\title{Common constraints}
\usage{
build_constraints(p, first = 0, sign = 0, monotone = 0, convex = 0)
}
\arguments{
\item{p}{The number of variables.}

\item{first}{Indicates sign constraint for first coefficient.
Recommended for identifiability if no other constraint is passed.}

\item{sign}{Sign constraint applied to all coefficients. \code{0}: no constraint,}

\item{monotone}{Monotonicity constraint. \code{0}: no constraint, \code{-1}:
decreasing coefficients and \code{1}: increasing coefficients.}

\item{convex}{Convexity constraint. \code{0}: no constraint, \code{-1}:
convex coefficients and \code{1}: concave coefficients.}
}
\value{
A p-column constraint matrix.
}
\description{
Build a constraint matrix from common simple constraints. Internally used
by \code{\link{g}} to construct index-specific constraint matrices.
}
\details{
For monotonicity and convexity / concavity, the function assumes the 
coefficients are ordered. For instance, for increasing monotone coefficients,
the first one will be lower than the second, which be lower than the
third and so on.

The function automatically removes redundant constraints. For instance,
if both \code{sign = 1} and \code{monotone = 1}, then only the sign
constraint on the first variable is kept as others are not needed.

Note that, for all arguments, any number can be passed to the function. In
which case, the sign of the argument is used. Therefore passing
\code{monotone = 3.14} is the same as passing \code{monotone = 1}.
}
\examples{
# By default, produces only the identifiability constraint
build_constraints(4)

# Positive and increasing coefficients
build_constraints(4, sign = 1, monotone = 1)

# Concavity constraint
build_constraints(7, convex = -1)

# Any numeric can be passed to the function
build_constraints(5, monotone = pi)

}
