% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{bsum}
\alias{bsum}
\title{Block Summation}
\usage{
bsum(x, block_size = 1)
}
\arguments{
\item{x, }{numeric vector or array, the object that is summed.}

\item{block_size, }{numeric scalar, the size of each block. Defaults to 1.}
}
\value{
numeric vector. Each 1th element of the vector is the sum of each 1th element of the blocks, the 2nd element of the vector is the sum of each 2nd element of the blocks, and so on.
}
\description{
Divide a vector or array in consecutive fixed-sized blocks and sum the elements at each position in these blocks.
}
\note{
If \code{x} is an array and \code{block_size} is equal to the size of \code{x}'s first dimension, then \link[cgraph]{bsum} behaves as \link[base:colSums]{rowSums}.
}
\author{
Ron Triepels
}
\keyword{internal}
