% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{cg_graph_get}
\alias{cg_graph_get}
\title{Retrieve Node}
\usage{
cg_graph_get(graph, name)
}
\arguments{
\item{graph}{cg_graph object, graph containing the node to be retrieved.}

\item{name}{character scalar, name of the node to be retrieved.}
}
\value{
cg_node object.
}
\description{
Retrieve a node from a graph by name.
}
\note{
In case multiple nodes share the same name, the last node added to the graph is retrieved.
}
\examples{
# Initialize a computational graph
graph <- cg_graph()

# Add an input
a <- cg_input(name = "a")

# Retrieve input a
b <- cg_graph_get(graph, "a")

# Check equality
identical(a, b)

}
\author{
Ron Triepels
}
