% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_arriv_times.R
\name{gen_arriv_times}
\alias{gen_arriv_times}
\title{Generate arrival times according to a Poisson point process}
\usage{
gen_arriv_times(psi, t)
}
\arguments{
\item{psi}{rate of the arrival process.}

\item{t}{time until which arrivals should be generated.}
}
\value{
A vector of arrival times up until time t.
}
\description{
This function can be used to generate arrival times for a Poisson point
process with rate psi up until time t.
}
\details{
Exponential(\eqn{\psi}) interarrival times.
}
\examples{
gen_arriv_times(psi = 0.3, t = 5)
}
\seealso{
Other utils: 
\code{\link{calc_risk}()},
\code{\link{exp_hazards}},
\code{\link{gen_surv_times}()},
\code{\link{runlength}()}
}
\author{
Daniel Gomon
}
\concept{utils}
