% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{anova.chandwich}
\alias{anova.chandwich}
\title{Comparison of nested models}
\usage{
\method{anova}{chandwich}(object, object2, ...)
}
\arguments{
\item{object}{An object of class \code{"chandwich"}, returned by
\code{\link{adjust_loglik}}.}

\item{object2}{An object of class \code{"chandwich"}, returned by
\code{\link{adjust_loglik}}.}

\item{...}{Further objects of class \code{"chandwich"} and/or arguments
to be passed to \code{\link{compare_models}}.  The name of any object
of class \code{"chandwich"} passed via ... must not match any argument of
\code{\link{compare_models}} or any argument of
\code{\link[stats]{optim}}.}
}
\value{
An object of class \code{"anova"} inheriting from class
 \code{"data.frame"}, with four columns:
    \item{Model.Df}{The number of parameters in the model}
    \item{Df}{The decrease in the number of parameter compared the model
      in the previous row}
    \item{ALRTS}{The adjusted likelihood ratio test statistic}
    \item{Pr(>ALRTS)}{The p-value associated with the test that the
      model is a valid simplication of the model in the previous row.}
 The row names are the names of the model objects.
}
\description{
\code{anova} method for objects of class \code{"chandwich"}.
Compares two or more nested models using the adjusted likelihood ratio
test statistic (ALRTS) described in Section 3.5 of
\href{http://dx.doi.org/10.1093/biomet/asm015}{Chandler and Bate (2007)}.
The nesting must result from the simple constraint that a subset of the
parameters of the larger model is held fixed.
}
\details{
For details the adjusted likelihood ratio test see
\code{\link{compare_models}} and Chandler and Bate (2007).

  The objects of class \code{"chandwich"} need not be provided in nested
  order: they will be ordered inside \code{anova.chandwich} based on the
  values of \code{attr(., "p_current")}.
}
\examples{
# -------------------------- GEV model, owtemps data -----------------------
# ------------ following Section 5.2 of Chandler and Bate (2007) -----------

gev_loglik <- function(pars, data) {
  o_pars <- pars[c(1, 3, 5)] + pars[c(2, 4, 6)]
  w_pars <- pars[c(1, 3, 5)] - pars[c(2, 4, 6)]
  if (isTRUE(o_pars[2] <= 0 | w_pars[2] <= 0)) return(-Inf)
  o_data <- data[, "Oxford"]
  w_data <- data[, "Worthing"]
  check <- 1 + o_pars[3] * (o_data - o_pars[1]) / o_pars[2]
  if (isTRUE(any(check <= 0))) return(-Inf)
  check <- 1 + w_pars[3] * (w_data - w_pars[1]) / w_pars[2]
  if (isTRUE(any(check <= 0))) return(-Inf)
  o_loglik <- log_gev(o_data, o_pars[1], o_pars[2], o_pars[3])
  w_loglik <- log_gev(w_data, w_pars[1], w_pars[2], w_pars[3])
  return(o_loglik + w_loglik)
}

# Initial estimates (method of moments for the Gumbel case)
sigma <- as.numeric(sqrt(6 * diag(var(owtemps))) / pi)
mu <- as.numeric(colMeans(owtemps) - 0.57722 * sigma)
init <- c(mean(mu), -diff(mu) / 2, mean(sigma), -diff(sigma) / 2, 0, 0)

# Log-likelihood adjustment of the full model
par_names <- c("mu[0]", "mu[1]", "sigma[0]", "sigma[1]", "xi[0]", "xi[1]")
large <- adjust_loglik(gev_loglik, data = owtemps, init = init,
         par_names = par_names)

# Log-likelihood adjustment of some smaller models: xi[1] = 0 etc

medium <- adjust_loglik(larger = large, fixed_pars = "xi[1]")
small <- adjust_loglik(larger = medium, fixed_pars = c("sigma[1]", "xi[1]"))
tiny <- adjust_loglik(larger = small,
                      fixed_pars = c("mu[1]", "sigma[1]", "xi[1]"))

anova(large, medium, small, tiny)
}
\references{
Chandler, R. E. and Bate, S. (2007). Inference for clustered
  data using the independence loglikelihood. \emph{Biometrika},
  \strong{94}(1), 167-183. \url{http://dx.doi.org/10.1093/biomet/asm015}
}
\seealso{
\code{\link{compare_models}} for an adjusted likelihood ratio test
  of two models.

\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood function.

\code{\link{conf_intervals}} for confidence intervals for
  individual parameters.

\code{\link{conf_region}} for a confidence region for
  pairs of parameters.
}
