% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cRRrmm.R
\name{buildRMM}
\alias{buildRMM}
\title{Create metadata objects from 'changeRangeR'}
\usage{
buildRMM(
  rmm = NULL,
  binaryRange = NULL,
  locs = NULL,
  AOOarea = NULL,
  PE = NULL,
  PhyloTree = NULL,
  complementarity = NULL,
  complementarity.of = NULL,
  complementarity.mask = NULL,
  envChange = NULL,
  envChange.rStack = NULL,
  envChange.binaryRange = NULL,
  envChange.threshold = NULL,
  envChange.bound = NULL,
  envChange.correlation = NULL,
  futureOverlap = NULL,
  futureOverlap.binRasters = NULL,
  futureOverlap.futures = NULL,
  mcp = NULL,
  mcpSDM = NULL,
  ratioOverlap = NULL,
  ratioOverlap.shape = NULL,
  ratioOverlap.field = NULL,
  SE = NULL,
  SE.ranges = NULL
)
}
\arguments{
\item{rmm}{A `rangemodelmetadata` object.}

\item{binaryRange}{Raster layer of a binary SDM. Must be either unprojected in the WGS84 datum, or projected in a UTM projection measured in meters.}

\item{locs}{`data.frame` of occurrence records: Longitude and latitude.}

\item{AOOarea}{The output of the function `AOOarea`.}

\item{PE}{The output of the function `calc_PE`.}

\item{PhyloTree}{class phylo object of phylogenetic tree. The names on tree's tip labels need to match the column names on the matrix.}

\item{complementarity}{The out put of the function `complementarity`.}

\item{complementarity.of}{`raster` of categorical values (e.g., a species richness map).}

\item{complementarity.mask}{`raster` object representing areas of interest (e.g., protected areas).}

\item{envChange}{The output of the function `envChange`}

\item{envChange.rStack}{`rasterStack` of environmental variable to measure within binary SDM through time.}

\item{envChange.binaryRange}{`raster` object or shapefile of binary range (SDM, AOO, EOO) with same projection as rStack.}

\item{envChange.threshold}{integer (or integers if bound = "both") of where rStack layers should be thresholded.}

\item{envChange.bound}{character string characterizing the way the threshold should happen. "upper" removes values above
the threshold (e.g., maximum human footprint)."lower" removes values below the threshold (e.g., minimum forest cover).
"neither" does not threshold at any point. "both" thresholds at both threshold values (if provided; e.g.,
minimum and maximum temperature).}

\item{envChange.correlation}{boolean. If FALSE, environmental variable will be converted to a binary map and used as a mask.
If TRUE, environmental variable is only thresholded by bounds, but left continuous. Then, Pearson's correlation
coefficient with SDM will be computed for overlapping areas.}

\item{futureOverlap}{The output of the function `futureOverlap`.}

\item{futureOverlap.binRasters}{`list` of rasters of binary SDMs..}

\item{futureOverlap.futures}{`list` of `SpatialPolygons*` objects with same CRS as futureOverlap.binRasters.}

\item{mcp}{The output of the function `mcp`}

\item{mcpSDM}{The output of the function `mcpSDM`}

\item{ratioOverlap}{The output of the function `ratioOverlap`}

\item{ratioOverlap.shape}{Either 1) a `shapefile` of land cover features or 2) a continuous `raster`. Must be in same projection as r parameter. If shp is a raster, then the number of cells within each quantile are calculated.}

\item{ratioOverlap.field}{A character string representing the shapefile field attribute containing the features to compare (i.e., the column name).}

\item{SE}{The output of the function `SE`}

\item{SE.ranges}{a `rasterStack` of binary species presences}
}
\value{
Populated rmm object
}
\description{
Creates and populates a 'rangeModelMetadata' object from the output of 'changeRangeR'.
See Merow et al. (2019) <doi:10.1111/geb.12993> for more details on the nature of the metadata and the 'rangeModelMetadata' package.
To improve reproducibility of the study, this metadata object can be used as supplemental information for a manuscript, shared with collaborators, etc.
}
\examples{
buildRMM(binaryRange = NULL)

}
\references{
Merow, C., Maitner, B. S., Owens, H. L., Kass, J. M., Enquist, B. J., Jetz, W., & Guralnick, R. (2019). Species' range model metadata standards: RMMS. \emph{Global Ecology and Biogeography}, \bold{28}: 1912-1924. \doi{10.1111/geb.12993}
}
\author{
pgalante@amnh.org
}
