% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{cpts.mv}
\alias{cpts.mv}
\alias{cpts.mv,changepoint.mv.mrc.class-method}
\title{Multivariate changepoint locations.}
\usage{
\S4method{cpts.mv}{changepoint.mv.mrc.class}(x, p = NULL)
}
\arguments{
\item{x}{An S4 object as returned by \code{\link{mrc}}.}

\item{p}{The number of most recent changepoints locations to be consisdered. Default value is \code{p=x@pmax} where pmax}
}
\value{
A list of \eqn{N} vectors containing the multivariate changepoint locations. Each vector corresponds to an individual variate in the data.
}
\description{
Returns a list of vectors containing the multivariate changepoint locations.
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample)
cpts.mv(res)
cpts.mv(res,p=3)

}
