% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{data.set}
\alias{data.set}
\alias{data.set,changepoint.mv.mrc.class-method}
\title{Recovers the data from the results of a changepoint analysis.}
\usage{
\S4method{data.set}{changepoint.mv.mrc.class}(x)
}
\arguments{
\item{x}{An S4 class instance obtained from \code{\link{mrc}}.}
}
\value{
A data frame containing the original data and an index variable (if \code{indexed=TRUE} was used for the analysis).
}
\description{
Recovers the data from the S4 class returned by  \code{\link{mrc}}. The data is stored in a data frame and, unless \code{indexed=TRUE}
was specified when the data was analysed, the first column will contain an index variable. If the original data did not have column names, default ones of the form V.n, where n is the column
number, will be added.
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample)
head(data.set(res))

}
