% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-provider.R
\name{FileProvider}
\alias{FileProvider}
\title{FileProvider}
\description{
file methods
}
\examples{
(x <- FileProvider$new())
x$locale
x$mime_type()
x$file_extension()
x$file_name()
x$file_path()
x$file_path(depth = 2)
x$file_path(depth = 3)
x$file_path(depth = 6)
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{FileProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) the locale}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileProvider-allowed_locales}{\code{FileProvider$allowed_locales()}}
\item \href{#method-FileProvider-new}{\code{FileProvider$new()}}
\item \href{#method-FileProvider-mime_type}{\code{FileProvider$mime_type()}}
\item \href{#method-FileProvider-file_name}{\code{FileProvider$file_name()}}
\item \href{#method-FileProvider-file_extension}{\code{FileProvider$file_extension()}}
\item \href{#method-FileProvider-file_path}{\code{FileProvider$file_path()}}
\item \href{#method-FileProvider-clone}{\code{FileProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-bothify'><code>charlatan::BaseProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-lexify'><code>charlatan::BaseProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-numerify'><code>charlatan::BaseProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit'><code>charlatan::BaseProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero'><code>charlatan::BaseProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero_or_empty'><code>charlatan::BaseProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_or_empty'><code>charlatan::BaseProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element'><code>charlatan::BaseProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element_prob'><code>charlatan::BaseProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_int'><code>charlatan::BaseProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_letter'><code>charlatan::BaseProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-randomize_nb_elements'><code>charlatan::BaseProvider$randomize_nb_elements()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-allowed_locales"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-allowed_locales}{}}}
\subsection{Method \code{allowed_locales()}}{
fetch the allowed locales for this provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$allowed_locales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{FileProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. See
\verb{$allowed_locales()} for locales supported (default: en_US)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{FileProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-mime_type"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-mime_type}{}}}
\subsection{Method \code{mime_type()}}{
a random mime type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$mime_type(category = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{category}}{(character) a mime type category of mime types, one
of application, audio, image, message, model, multipart, text or
video. default: \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-file_name"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-file_name}{}}}
\subsection{Method \code{file_name()}}{
a random file name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$file_name(category = NULL, extension = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{category}}{(character) a category of file extension type, one of
audio, image, office, text or video. default: \code{NULL}. If this is
given, \code{extension} is ignored}

\item{\code{extension}}{(character) a file extension. if this is given,
\code{category} is ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-file_extension"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-file_extension}{}}}
\subsection{Method \code{file_extension()}}{
a random file extension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$file_extension(category = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{category}}{(character) a category of file extension type, one of
audio, image, office, text or video. default: \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-file_path"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-file_path}{}}}
\subsection{Method \code{file_path()}}{
a random file path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$file_path(depth = 1, category = NULL, extension = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{depth}}{(character) depth of the file (depth >= 0). default: 1}

\item{\code{category}}{(character) a category of file extension type, one of
audio, image, office, text or video. default: \code{NULL}. If this is
given, \code{extension} is ignored}

\item{\code{extension}}{(character) a file extension. if this is given,
\code{category} is ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
