% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageVariation4R.R
\name{imageVariation4R}
\alias{imageVariation4R}
\title{Generate Image Variations using OpenAI API}
\usage{
imageVariation4R(
  image,
  n = 3,
  size = "256x256",
  response_format = "url",
  Output_image = TRUE,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{image}{A string. This is the path to the image file to be used as the basis for the variations.
Must be a valid PNG file, less than 4MB, and square.}

\item{n}{An integer. This is the number of image variations to generate.
Must be between 1 and 10. The default is 3.}

\item{size}{A string. This is the size of the generated images.
Must be one of 256x256, 512x512, or 1024x1024.}

\item{response_format}{A string. This is the format in which the generated images are returned.
Must be one of "url" or "b64_json". The default is "url".}

\item{Output_image}{A boolean. If TRUE, the output will be images themselves.
If FALSE, the output will be URLs pointing to the images. The default is TRUE.}

\item{api_key}{A string. This is your OpenAI API key. By default, it uses the key stored in the OPENAI_API_KEY environment variable.}
}
\value{
A list. This list contains either URLs pointing to the generated images
or the images themselves in base64 encoded JSON format, depending on the `Output_image` parameter.
}
\description{
Generates variations of a given image using the OpenAI API.
It generates n number of variations of a provided image.
The output can either be a list of URLs pointing to the generated images or the images themselves in base64 encoded JSON format.
}
\details{
Generate Image Variations using OpenAI

This function generates variations of a given image using OpenAI's image API.
It uses OpenAI's image API to generate a specified number of variations for a provided image.
}
\examples{
\dontrun{
# Define the path to the image
image_path = "path_to_your_image.png"

# Generate image variations
res <- imageVariation4R(image = image_path, n = 3, size = "256x256",
response_format = "url", Output_image = TRUE)

# Display the generated image variations
Display(res)
}
}
\author{
Satoshi Kume
}
