#' ChatGPT: Create Unit Tests
#'
#' Create `{testthat}` test cases for the code.
#'
#' @param code The code for which to create unit tests by ChatGPT.
#'
#' @examples
#' \dontrun{
#' cat(create_unit_tests("squared_numbers <- function(numbers) {\n  numbers ^ 2\n}"))
#' }
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
create_unit_tests <- function(code) {
  prompt <- paste0(
    'Create a full testthat file, with test cases for the following R code: "', code, '"'
  )
  trimws(sapply(gpt_get_completions(prompt)$choices, function(x) x$text))
}
