% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.chtrs}
\alias{plot.chtrs}
\alias{hist.chtrs}
\title{Plot cheatrs / histogram of similarity scores}
\usage{
\method{plot}{chtrs}(x, weight_range = c(0.4, 1), remove_lonely = TRUE, digits = 0, ...)

\method{hist}{chtrs}(x, ...)
}
\arguments{
\item{x}{output of \code{\link[=catch_em]{catch_em()}}.}

\item{weight_range}{range of edge values to plot}

\item{remove_lonely}{should lonely nodes (not connected to any edges) be
removed from the graph?}

\item{digits}{Number of digits to round the percentage to.}

\item{...}{passed to \code{\link[ggraph:ggraph]{ggraph::ggraph()}} or \link[ggplot2:geom_histogram]{ggplot2::geom_histogram}.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Requires \code{ggraph} and \code{ggplot2} to work.
}
\examples{
if (interactive()) {
  files <- choose.files()
  res <- catch_em(files)

  plot(res)
  hist(res)
}

}
\author{
Mattan S. Ben-Shachar
}
