% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebyshev.R
\name{chebeval}
\alias{chebeval}
\title{Evaluate a Chebyshev interpolation in a point}
\usage{
chebeval(x, coef, intervals = NULL,
  threads = getOption("chebpol.threads"))
}
\arguments{
\item{x}{The point to evaluate.}

\item{coef}{The Chebyshev coefficients. Typically from a call to
\code{\link{chebcoef}}, possibly modified.}

\item{intervals}{A list of minimum and maximum values. One for each
dimension of the hypercube.}

\item{threads}{And integer. In case \code{x} is a matrix of column vectors,
use this number of threads in parallel to evaluate.}
}
\value{
A numeric. The interpolated value.
}
\description{
Given Chebyshev coefficients, evaluate the interpolation in a point.
}
\examples{

# make a function which is known to be unsuitable for Chebyshev approximation
f <- function(x) sign(x)
# make a standard Chebyshev interpolation
ch <- ipol(f,dims=50,method='chebyshev')
# then do a truncated interpolation
val <- evalongrid(f,50)
coef <- chebcoef(val)
# truncate the high frequencies
coef[-(1:10)] <- 0
# make a truncated approximation
tch <- Vectorize(function(x) chebeval(x,coef))
# make a lower degree also
ch2 <- ipol(f,dims=10,method='chebyshev')
# plot the functions
\dontrun{
s <- seq(-1,1,length.out=400)
plot(s,ch(s),col='red',type='l')
lines(s,tch(s),col='blue')
lines(s,f(s))
lines(s,ch2(s),col='green')
}

}
