% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.checkglobalsi}
\alias{print.checkglobalsi}
\title{Print \code{"checkglobalsi"} object}
\usage{
\method{print}{checkglobalsi}(x, format = "basic", pattern, ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobalsi"}.}

\item{format}{character, one of the following two choices:
\itemize{
\item \code{"basic"}, (default) prints only the name and source code location of the detected imports.
\item \code{"detail"}, prints the name and location of the detected imports, as well as the
lines in the source code file comprising the detected imports. The maximum number of lines
printed per source code reference can be specified using \code{maxLines}.
}}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{...}{additional arguments to configure the printed output.
The following arguments can be specified:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{maxRef}, the maximum number of printed source code references per detected global/import.
Defaults to 1.
\item \code{maxLines}, the maximum number of printed lines per source code reference, only used if
\code{format = "detail"}. Defaults to 5.
\item \code{use_cli}, a logical value indicating if \code{cli} should be used to format the printed output.
Defaults to \code{TRUE}, which means that \code{cli}-formatting is attempted if \code{cli} is installed.
\item \code{maxWidth}, the maximum column width of the printed output. If \code{cli} is installed, the default
width is determined by \code{cli::console_width()}. If \code{cli} is not installed, \code{getOption("width")}
is checked. If \code{getOption("width")} is undefined, the column width defaults to 80.
}}
}
\value{
Returns the object \code{x} \emph{invisibly} (via \code{\link{invisible}})
}
\description{
Print method for S3-objects of class \code{"checkglobalsi"} characteristic
to the \code{"imports"} list element of \code{"checkglobals"} objects returned by \code{\link{checkglobals}},
\code{\link{check_pkg}} or \code{\link{check_source}}.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
chk$imports

## print selected imports
print(chk, format = "detail", pattern = "coef", which = "import", maxRef = 99)

## print without cli-formatting
print(chk$imports, use_cli = FALSE)
}
