% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_as_cran.R
\name{check_as_cran}
\alias{check_as_cran}
\title{Check your package with real CRAN default environment variables and check strategy}
\usage{
check_as_cran(
  pkg = ".",
  check_output = tempfile("check_output"),
  scratch = tempfile("scratch_dir"),
  Ncpus = 1,
  as_command = FALSE,
  clean_before = TRUE,
  open = FALSE
)
}
\arguments{
\item{pkg}{pkg directory to check}

\item{check_output}{Where to store check outputs. Default is a temporary directory}

\item{scratch}{Where to store temporary files (cleaned after). Default is another temporary directory}

\item{Ncpus}{Number of CPU used to build the package}

\item{as_command}{Whether to run the check as Linux command line, instead of directly in R}

\item{clean_before}{Whether to delete the previous check_output}

\item{open}{Whether to open the check dir at the end of the process}
}
\value{
An object containing errors, warnings, and notes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
When you send your package on CRAN, there are multiple options set before running the checks.
Here we use the CRAN settings and way of managing incoming packages used for Linux in this function \code{check_as_cran()}.

Scripts and options used are directly issued from the GitHub mirror repository of the CRAN machines: \url{https://github.com/r-devel/r-dev-web/tree/master/CRAN/}.
Although \code{check_as_cran()} should run on any OS, it will run CRAN parameters originally set up for Linux machines.

In the \code{check_output}, you will get the same outputs, in the same format as used by CRAN, for the pre-test of incoming packages.
}
\examples{
\dontrun{
# This runs a check of the current package
# Directory to store the check outputs
check_output <- tempfile("example")
# Check the current package
check_as_cran(check_output = check_output)
# Open directory with all outputs
utils::browseURL(check_output)
}
}
\references{
https://github.com/r-devel/r-dev-web/tree/master/CRAN/
}
