% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkString.r
\name{checkString}
\alias{assertString}
\alias{assert_string}
\alias{checkString}
\alias{expect_string}
\alias{testString}
\alias{test_string}
\title{Check if an argument is a string}
\usage{
checkString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE)

assertString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, add = NULL, .var.name)

assert_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, add = NULL, .var.name)

testString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE)

test_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE)

expect_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{min.chars}{[\code{integer(1)}]\cr
Minimum number of characters in each element of \code{x}.}

\item{pattern}{[\code{character(1L)}]\cr
Regular expression as used in \code{\link[base]{grepl}}.
All elements of \code{x} must comply to this pattern.}

\item{fixed}{[\code{character(1)}]\cr
Substring to detect in \code{x}. Will be used as \code{pattern} in \code{\link[base]{grepl}}
with option \code{fixed} set to \code{TRUE}.
All elements of \code{x} must contain this substring.}

\item{ignore.case}{[\code{logical(1)}]\cr
See \code{\link[base]{grepl}}. Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertString}/\code{assert_string}
 throws an error message, \code{testString}/\code{test_string}
 returns \code{FALSE},
 and \code{checkString} returns a string with the error message.
 The function \code{expect_string} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
A string is defined as a scalar character vector.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testString("a")
testString(letters)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkNumber}}, \code{\link{checkScalarNA}},
  \code{\link{checkScalar}}
}

