% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkEnvironment.R
\name{checkEnvironment}
\alias{checkEnvironment}
\alias{check_environment}
\alias{assertEnvironment}
\alias{assert_environment}
\alias{testEnvironment}
\alias{test_environment}
\alias{expect_environment}
\title{Check if an argument is an environment}
\usage{
checkEnvironment(x, contains = character(0L), null.ok = FALSE)

check_environment(x, contains = character(0L), null.ok = FALSE)

assertEnvironment(x, contains = character(0L), null.ok = FALSE,
  .var.name = vname(x), add = NULL)

assert_environment(x, contains = character(0L), null.ok = FALSE,
  .var.name = vname(x), add = NULL)

testEnvironment(x, contains = character(0L), null.ok = FALSE)

test_environment(x, contains = character(0L), null.ok = FALSE)

expect_environment(x, contains = character(0L), null.ok = FALSE,
  info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{contains}{[\code{character}]\cr
Vector of object names expected in the environment.
Defaults to \code{character(0)}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertEnvironment}/\code{assert_environment} return 
 \code{x} invisibly, whereas
 \code{checkEnvironment}/\code{check_environment} and 
 \code{testEnvironment}/\code{test_environment} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertEnvironment}/\code{assert_environment}
 throws an error message, 
 \code{testEnvironment}/\code{test_environment}
 returns \code{FALSE},
 and \code{checkEnvironment} returns a string with the error message.
 The function \code{expect_environment} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is an environment
}
\examples{
ee = as.environment(list(a = 1))
testEnvironment(ee)
testEnvironment(ee, contains = "a")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDate}}, \code{\link{checkFactor}},
  \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNull}}, \code{\link{checkNumeric}},
  \code{\link{checkPOSIXct}}, \code{\link{checkVector}}
}
