% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{check_name}
\alias{check_name}
\title{Check Name}
\usage{
check_name(x, x_name = substitute(x), coerce = FALSE, error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of the object.}

\item{coerce}{A flag specifying whether to coerce a factor to a character vector and drop attributes including names.}

\item{error}{A flag indicating whether to throw an informative error or 
immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether each element of a character vector is a syntactically valid name.
}
\examples{
vec <- c("x", "x.y", "x y")
check_name(vec, error = FALSE)
}
\seealso{
\code{\link{check_character}}
}
