% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{check_neg_int}
\alias{check_neg_int}
\title{Check Negative Int}
\usage{
check_neg_int(x, coerce = FALSE, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a numeric (dbl) whole number to an int and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a negative int (non-missing integer scalar with no attributes including names).
}
\examples{
check_neg_int(0L, error = FALSE)
check_neg_int(-1L, error = FALSE)
}
\seealso{
\code{\link{check_int}}
}
