% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar.R
\name{check_scalar}
\alias{check_scalar}
\title{Check Scalar}
\usage{
check_scalar(x, values = NULL, named = FALSE, attributes = named,
  only = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{values}{NULL or a vector specifying the values.}

\item{named}{A flag indicating whether the scalar must be named or unnamed or NA if it doesn't matter if the scalar is named.}

\item{attributes}{A flag indicating whether the scalar must or must not have attributes or NA if it doesn't matter if the scalar is named.}

\item{only}{A flag indicating whether only the actual values are permitted.
It only affects values with two or less non-missing elements.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether an object is an atomic vector with one element.
}
\examples{
check_scalar(1)
check_scalar(c(1,2), error = FALSE)
check_scalar(1, c(2,3), error = FALSE)
}
\seealso{
\code{\link{check_vector}}
}
