% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_treeshap_minimal_port.r
\name{lightgbm.unify}
\alias{lightgbm.unify}
\title{Unify LightGBM model}
\source{
\strong{treeshap}, \url{https://github.com/ModelOriented/treeshap}
}
\usage{
lightgbm.unify(lgb_model, data, recalculate = FALSE)
}
\arguments{
\item{lgb_model}{A lightgbm model - object of class \code{lgb.Booster}}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}

\item{recalculate}{logical indicating if covers should be recalculated according to the dataset given in data. Keep it \code{FALSE} if training data are used.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your LightGBM model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Fit a model:
param_lgbm <- list(num_leaves = 50, objective = "regression")
lightgbm_model <- lightgbm::lightgbm(
  as.matrix(X), Y, params = param_lgbm, 
  nrounds = 2, verbose = 0)
unified_model <- lightgbm.unify(lightgbm_model, X)
## Delete model file if it exists
if(file.exists("lightgbm.model"))
  file.remove("lightgbm.model")

## Calculate treeSHAP:
shaps <- treeshap(unified_model, X[1:2, ])
str(shaps)
}
\seealso{
\code{\link{unify_tree_model}}, a wrapper function unifying these models.
\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}
\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}
\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}
\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
\author{
Konrad Komisarczyk, Przemyslaw Biecek, et al.
}
