% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ael03.R
\docType{data}
\name{ael03_main}
\alias{ael03_main}
\alias{ael03_pre}
\alias{ael03}
\title{\code{AEL03} Listing 1 (Default) Listing of Serious Adverse Events.}
\format{
An object of class \code{chevron_l} of length 1.
}
\usage{
ael03_main(
  adam_db,
  dataset = "adae",
  key_cols = c("ID", "ASR"),
  disp_cols = c("AEDECOD", "TRTSDTM", "ASTDY", "ADURN", "ASEV", "AREL", "AEOUT",
    "AECONTRT", "AEACN", "SERREAS"),
  split_into_pages_by_var = "ACTARM",
  unique_rows = FALSE,
  ...
)

ael03_pre(adam_db, dataset = "adae", arm_var = "ACTARM", ...)

ael03
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{key_cols}{(\code{character}) names of columns that should be treated as key columns when rendering the listing.
Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character}) names of non-key columns which should be displayed when the listing is rendered.}

\item{split_into_pages_by_var}{(\code{character} or \code{NULL}) the name of the variable to split the listing by.}

\item{unique_rows}{(\code{flag}) whether to keep only unique rows in listing.}

\item{...}{not used.}

\item{arm_var}{(\code{string}) variable used for column splitting}
}
\value{
the main function returns an \code{rlistings} or a \code{list} object.
}
\description{
\code{AEL03} Listing 1 (Default) Listing of Serious Adverse Events.
}
\section{Functions}{
\itemize{
\item \code{ael03_main()}: Main TLG function

\item \code{ael03_pre()}: Preprocessing

}}
\examples{
res <- run(ael03, syn_data)
}
\keyword{datasets}
