% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbt06.R
\docType{data}
\name{lbt06_main}
\alias{lbt06_main}
\alias{lbt06_pre}
\alias{lbt06_post}
\alias{lbt06}
\title{\code{LBT06} Table 1 (Default) Laboratory Abnormalities by Visit and Baseline Status Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
lbt06_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  page_var = "PARAMCD",
  ...
)

lbt06_pre(adam_db, ...)

lbt06_post(tlg, prune_0 = FALSE, ...)

lbt06
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) the arm variable used for arm splitting.}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{LBT06} table produces the standard laboratory abnormalities by visit and
baseline status summary.
}
\details{
\itemize{
\item Only count \code{"LOW"} or \code{"HIGH"} values for \code{ANRIND} and \code{BNRIND}.
\item Lab test results with missing \code{ANRIND} values are excluded.
\item Split columns by arm, typically \code{ACTARM}.
\item Keep zero count rows by default.
}
}
\section{Functions}{
\itemize{
\item \code{lbt06_main()}: Main TLG function

\item \code{lbt06_pre()}: Preprocessing

\item \code{lbt06_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adlb} table with columns \code{"AVISIT"}, \code{"ANRIND"}, \code{"BNRIND"},
\code{"ONTRTFL"}, and \code{"PARCAT2"}, and column specified by \code{arm_var}.
}
}
\examples{
run(lbt06, syn_data)
}
\keyword{datasets}
