% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbt07.R
\docType{data}
\name{lbt07_main}
\alias{lbt07_main}
\alias{lbt07_pre}
\alias{lbt07_post}
\alias{lbt07}
\title{\code{LBT07} Table 1 (Default) Laboratory Test Results and Change from Baseline by Visit.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
lbt07_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  param_var = "PARAM",
  grad_dir_var = "GRADE_DIR",
  grad_anl_var = "GRADE_ANL",
  ...
)

lbt07_pre(adam_db, ...)

lbt07_post(tlg, prune_0 = TRUE, ...)

lbt07
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{param_var}{(\code{string}) the name of the column storing the parameters name.}

\item{grad_dir_var}{(\code{string}) the name of the column storing the grade direction variable which  is required in
order to obtain the correct denominators when building the layout as it is used to define row splitting.}

\item{grad_anl_var}{(\code{string})  the name of the column storing toxicity grade variable where all negative values from
\code{ATOXGR} are replaced by their absolute values.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{LBT07} table provides an
overview of the analysis values and its change from baseline of each respective arm over the course of the trial.
}
\details{
\itemize{
\item Split columns by arm, typically \code{ACTARM}.
}
}
\section{Functions}{
\itemize{
\item \code{lbt07_main()}: Main TLG function

\item \code{lbt07_pre()}: Preprocessing

\item \code{lbt07_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adlb} table with columns \code{"USUBJID"}, \code{"ATOXGR"},
\code{"ONTRTFL"} and column specified by \code{arm_var}.
}
}
\examples{
run(lbt07, syn_data)
}
\keyword{datasets}
