% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmt01.R
\docType{data}
\name{dmt01_main}
\alias{dmt01_main}
\alias{dmt01_pre}
\alias{dmt01_post}
\alias{dmt01}
\title{\code{DMT01} Table 1 (Default) Demographics and Baseline Characteristics Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
dmt01_main(
  adam_db,
  arm_var = "ARM",
  lbl_overall = "All {Patient_label}",
  summaryvars = c("AAGE", "AGEGR1", "SEX", "ETHNIC", "RACE"),
  stats = list(default = c("n", "mean_sd", "median", "range", "count_fraction")),
  precision = list(),
  ...
)

dmt01_pre(adam_db, ...)

dmt01_post(tlg, prune_0 = TRUE, ...)

dmt01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{summaryvars}{(\code{character}) variables summarized in demographic table. The label attribute of the corresponding
column in \code{adsl} table of \code{adam_db} is used as label.}

\item{stats}{(named \code{list} of character)  where names of columns found in \code{.df_row} and the values indicate the
statistical analysis to perform. If \code{default} is set, and parameter precision not specified, the
value for \code{default} will be used.}

\item{precision}{(named \code{list} of \code{integer}) where names are \code{strings} found in \code{summaryvars} and the values indicate
the number of digits in statistics for numeric variables. If \code{default} is set, and parameter precision not
specified, the value for \code{default} will be used. If neither are provided, auto determination is used. See
\code{\link[tern:format_auto]{tern::format_auto}}.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
For each variable, summary statistics are
by default based on the number of patients in the corresponding \code{n} row.
}
\details{
\itemize{
\item Information from \code{ADSUB} are generally included into \code{ADSL} before analysis.
\item Default demographic and characteristics table
\item If not specified otherwise, numbers represent absolute numbers of patients and fraction of \code{N}
\item Remove zero-count rows
\item Split columns by arm (planned or actual / code or description)
\item Include a total column by default
}
}
\section{Functions}{
\itemize{
\item \code{dmt01_main()}: Main TLG function

\item \code{dmt01_pre()}: Preprocessing

\item \code{dmt01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adsl} table with the columns specified in \code{summaryvars}.
}
}
\examples{
run(dmt01, syn_data)
}
\keyword{datasets}
