\name{make_chill_plot}

\alias{make_chill_plot}

\title{Plot climate metrics over time}

\description{This function generates a plot of a climate metric over multiple years, including an indication of data quality, i.e. the share of missing values. Output can be either an R plot or a .png image}

\usage{make_chill_plot(chill,model,start_year=1990,end_year=2020,metriclabel=NULL,
misstolerance=10,image_type=NA,outpath=NA,filename=NA,fonttype='serif')}

\arguments{
  \item{chill}{a chill object generated either with the chilling function or with tempResponse. For this function to work properly, the chill object should have been subjected to quality control (i.e. metrics should have been calculated from weather records with a QC element. If you prepare weather data with fix_weather, this should work.)}
   \item{model}{the name of the column of the chill object that contains the metric to be displayed}
   \item{start_year}{the first year shown in the diagram. Note that the default is 1950, and the function does not automatically remove years for which there is no data.}
   \item{end_year}{the last year shown in the diagram. Note that the default is 2020, and the function does not automatically remove years for which there is no data.}
   \item{metriclabel}{character string that can be used for labeling the y-axis in the plot. If this is not specified, the function will use the model argument.}
    \item{misstolerance}{Percentage of missing values that leads to exclusion of an annual value from plotting.}
   \item{image_type}{Character string indicating the file format that should be output. Image files are only produced for the moment, if this is "png". All other values, as well as the default NA lead to output as an R plot only.}
   \item{outpath}{Path to the folder where the images should be saved. Should include a trailing "/". The folder must already exists.}
   \item{filename}{Suffix of the filenames for output graph files. These will be amended by the name of the metric and by the file extension.}
   \item{fonttype}{The type of font to be used for the figures. Can be 'serif' (default) for a Times New Roman like font, 'sans' for an Arial type font or 'mono' for a typewriter type font.}
}

\details{Plots climatic metrics computed with chilling or tempResponse, indicating the completeness of the temperature record by shades of gray.}

\value{ only a side effect - plot of climate metric over time; bars are color coded according to the number of missing values. Bars with numbers of missing values above the misstolerance are not show and instead marked '*' (to distinguish them from 0 counts)}

\author{Eike Luedeling}

\examples{
make_chill_plot(tempResponse(stack_hourly_temps(fix_weather(KA_weather[KA_weather$Year>2005,]))),
"Chill_Portions",start_year=1990,end_year=2010,metriclabel="Chill Portions")

 }
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ utility }

