% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{params}
\alias{params}
\title{Parameters for chk functions}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}

\item{y}{An object to check against.}

\item{chk}{A flag specifying whether to check the other parameters.}

\item{chk_fun}{A chk_ function.}

\item{tolerance}{A non-negative numeric scalar.}

\item{ext}{A character vector of the permitted file extensions
(without the .).}

\item{value}{A non-missing scalar of a value.}

\item{range}{A non-missing sorted vector of length 2 of the lower and
upper permitted values.}

\item{regexp}{A string of a regular expression.}

\item{values}{A vector of the permitted values.}

\item{class}{A string specifying the class.}

\item{formals}{A count of the number of formal arguments.}

\item{incomparables}{A vector of values that cannot be compared.
FALSE means that all values can be compared.}

\item{by}{A character vector specifying the column names to join x and y on.
If named the names are the corresponding columns in x.}

\item{exclusive}{A flag specifying whether x must only include columns named in values.}

\item{order}{A flag specifying whether the order of columns in x must match names in values.}

\item{nrow}{A flag or a whole numeric vector of the value, value range or possible values.}

\item{key}{A character vector of the columns that represent a unique key.}

\item{vld_fun}{A vld_ function.}

\item{...}{Additional arguments.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Descriptions of the parameters and return values for the chk functions
}
\keyword{internal}
