% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\name{add_key}
\alias{add_key}
\title{Combine 2 keys with base key taking precedence}
\usage{
add_key(base, added, trim, verbose = TRUE)
}
\arguments{
\item{base}{the base key}

\item{added}{the key from which other antipsychotics are found to add}

\item{trim}{TRUE to use trim_key on both the base and added key, needed when
one does not use the full names (e.g. leucht2016).}

\item{verbose}{If TRUE, added antipsychotic names will be shown in a message}
}
\value{
a merged key
}
\description{
Use this to combine 2 keys by using the whole "base" key, and adding any
antipsychotics from the "added" key that are not in the "base" key.
}
\examples{
add_key(gardner2010, leucht2016, trim = TRUE)
}
\seealso{
Other key functions: \code{\link{check_key}},
  \code{\link{trim_key}}
}
\concept{key functions}
