% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_rt.R
\name{correct_peaks}
\alias{correct_peaks}
\title{Correct peak positions according to a ptw warping model}
\usage{
correct_peaks(peak_list, mod_list)
}
\arguments{
\item{peak_list}{A nested list of peak tables: the first level is the sample,
and the second level is the component. Every component is described by a
matrix where every row is one peak, and the columns contain information on
retention time, full width at half maximum (FWHM), peak width, height, and
area.}

\item{mod_list}{A list of ptw models.}
}
\value{
The input list of peak tables is returned with extra columns
containing the corrected retention time.
}
\description{
Corrects retention time differences using parametric time warping as 
implemented in \code{\link[ptw]{ptw}}.
}
\details{
Once an appropriate warping model has been established, corrected retention
times can be predicted for each peak. These are stored in a separate column
in the list of peak tables.
}
\seealso{
\code{\link{correct_rt}}
}
\author{
Ron Wehrens
}
