% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Find peaks in chromatographic profile}
\usage{
find_peaks(
  y,
  smooth_type = "gaussian",
  smooth_window = 1,
  smooth_width = 0.1,
  slope_thresh = 0,
  amp_thresh = 0,
  bounds = TRUE
)
}
\arguments{
\item{y}{response (numerical vector)}

\item{smooth_type}{Type of smoothing. (Defaults to "gaussian").}

\item{smooth_window}{Window for smoothing. (Defaults to 1).}

\item{smooth_width}{Width for smoothing. (Defaults to 0.1).}

\item{slope_thresh}{Minimum threshold for peak slope. (Defaults to 0).}

\item{amp_thresh}{Minimum threshold for peak amplitude. (Defaults to 0).}

\item{bounds}{Logical. If TRUE, includes peak boundaries in data.frame.
(Defaults to TRUE).}
}
\value{
If bounds == TRUE, returns a data.frame containing the center, start,
and end of each identified peak. Otherwise, returns a numeric vector of peak
centers. All locations are expressed as indices.
}
\description{
Find peaks in chromatographic profile.
}
\details{
Find peaks with function \code{find_peaks} by looking for zero-crossings in
the smoothed first derivative of a signal that exceed a given slope
threshold.
}
\note{
The \code{find_peaks} function is adapted from matlab code in Prof.
Tom O'Haver's
\href{http://terpconnect.umd.edu/~toh/spectrum/PeakFindingandMeasurement.htm}{
Pragmatic Introduction to Signal Processing}.
}
\examples{
data(Sa_pr)
find_peaks(Sa_pr[[1]][,"220"])
}
\references{
O'Haver, Tom. Pragmatic Introduction to Signal Processing:
Applications in scientific measurement.
/href{https://terpconnect.umd.edu/~toh/spectrum/} (Accessed January, 2022).
}
\seealso{
\code{\link{fit_peaks}}, \code{\link{get_peaks}}
}
\author{
Ethan Bass
}
