% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_peaks.R
\name{combine_peaks}
\alias{combine_peaks}
\title{Combine peaks in peak table}
\usage{
combine_peaks(peak_table, tol = 0.01, min.cor = 0.9, choose = "max")
}
\arguments{
\item{peak_table}{Peak table from \code{\link{get_peaktable}}.}

\item{tol}{Tolerance for matching retention times (maximum retention time
difference).}

\item{min.cor}{Minimum spectral correlation to confirm a match.}

\item{choose}{If "max" will retain peak with highest intensity. Otherwise,
the first column in the data.frame will be retained.}
}
\value{
A peak table similar to the input peak table, but with duplicate
columns combined according to the specified criteria.
}
\description{
Utility function to combine duplicate peaks in peak table, i.e. peaks that
were integrated at more than one wavelength or component. Specify tolerance
(\code{tol}) for retention time matching and minimum spectral correlation
(\code{min.cor}) for a match.
}
\examples{
data(pk_tab)
data(Sa_warp)
pk_tab <- attach_ref_spectra(pk_tab)
combine_peaks(pk_tab, tol = .02, min.cor = .9)
}
\seealso{
\code{\link{get_peaks}}
}
\author{
Ethan Bass
}
