% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cifti_separate.R
\name{read_cifti_separate}
\alias{read_cifti_separate}
\title{Read a CIFTI file with optional resampling}
\usage{
read_cifti_separate(
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  resamp_res = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{surfL_fname}{(Optional) File path to a GIFTI surface geometry
file representing the left cortex.}

\item{surfR_fname}{(Optional) File path to a GIFTI surface geometry
file representing the right cortex.}

\item{brainstructures}{Character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortex), \code{"right"} (right cortex)
and/or \code{"subcortical"} (subcortex and cerebellum). Can also be
\code{"all"} (obtain all three brain structures). Default:
\code{c("left","right")} (cortex only).

If a brain structure is indicated but does not exist in the CIFTI file, a
warning will occur and that brain structure will be skipped.}

\item{idx}{Numeric vector indicating the data indices (columns) to read. If
\code{NULL} (default), read in all the data. Must be a subset of the indices
present in the file, or an error will occur.

For high-resolution CIFTI files, reading in only a subset of the data saves
memory, but will be slower than reading in the entire file due to the
required intermediate steps.}

\item{resamp_res}{(Optional) Target resolution for resampling (number of
cortical surface vertices per hemisphere). If \code{NULL} (default) or
\code{FALSE}, do not perform resampling.}

\item{mwall_values}{If the medial wall locations are not indicated in the
CIFTI, use these values to infer the medial wall mask. Default:
\code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer the medial wall.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\value{
A \code{"xifti"} object. See \code{\link{is.xifti}}.
}
\description{
Read a CIFTI file by writing each component into a GIFTI and NIFTI file
(\code{\link{separate_cifti}}), optionally resampling the GIFTIs,
(\code{\link{resample_gifti}}), and then reading each separated
component into R (\code{\link{make_xifti}}). Surfaces can also be provided;
they will be resampled along with the CIFTI for viewing.
}
\details{
The subcortical component (NIFTI) is not resampled.
}
\keyword{internal}
