% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.xifti.R
\name{is.surf}
\alias{is.surf}
\title{Validate a \code{"surf"} object (vertices + faces)}
\usage{
is.surf(x)
}
\arguments{
\item{x}{The putative \code{"surf"}.}
}
\value{
Logical. Is \code{x} a valid \code{"surf"}?
}
\description{
Check if object is valid for \code{xifti$surf$cortex_left} or
\code{xifti$surf$cortex_right}, where \code{xifti} is a \code{"xifti"}
object.
}
\details{
This is a helper function for \code{\link{is.xifti}}.

Requirements: the \code{"surf"} must be a list of three components: "vertices",
"faces", and "hemisphere". The first two should each be a numeric matrix
with three columns. The values in "vertices" represent spatial coordinates
whereas the values in "faces" represent vertex indices defining the face.
Thus, values in "faces" should be integers between 1 and the number of
vertices. The last list entry, "hemisphere", should be "left", "right",
or NULL indicating the brain hemisphere which the surface represents.
}
\seealso{
Other functions for working with GIFTI surface geometry data: 
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{view_surf}()},
\code{\link{write_surf_gifti}()}
}
\concept{surfing}
