% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_xifti.R
\name{view_xifti}
\alias{view_xifti}
\alias{view_cifti}
\alias{viewCIfTI}
\alias{viewcii}
\title{View a \code{"xifti"} object}
\usage{
view_xifti(xifti, what = NULL, ...)

view_cifti(xifti, ...)

viewCIfTI(xifti, ...)

viewcii(xifti, ...)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{what}{\code{"surface"}, \code{"volume"}, or \code{"both"}. \code{NULL}
will infer based on the contents of the \code{"xifti"}: if there is data,
plot the surface cortex data if present, and the volumetric subcortical data
otherwise. If there is no data, plot the surface geometry if present, and
do nothing otherwise.}

\item{...}{Additional arguments to pass to either view function.}
}
\value{
The return value of \code{view_xifti_surface} or
\code{view_xifti_volume}.
}
\description{
Displays the data in a \code{"xifti"} object using \code{\link{view_xifti_surface}}
and/or \code{\link{view_xifti_volume}}. Compared to calling these two
functions separately on the same data, this function may be more convenient
since the automatic choice of color mode and limits is determined across
the entire data and shared between the two plots. Also, if writing files
the subcortical plots will not overwrite the cortical plots.
}
