% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_xifti_volume.R
\name{view_xifti_volume}
\alias{view_xifti_volume}
\alias{view_cifti_volume}
\alias{viewCIfTI_volume}
\alias{viewcii_volume}
\title{View subcortical data in a \code{"xifti"}}
\usage{
view_xifti_volume(
  xifti,
  structural_img = "MNI",
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  structural_img_colors = gray(0:255/280),
  title = NULL,
  idx = NULL,
  plane = c("axial", "sagittal", "coronal"),
  convention = c("neurological", "radiological"),
  n_slices = 9,
  slices = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  widget = FALSE,
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  fname_sub = FALSE,
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  ypos.title = 0,
  xpos.title = 0,
  orientation_labels = TRUE,
  crop = TRUE,
  text_color = "white",
  bg = NULL,
  width = NULL,
  height = NULL,
  ...
)

view_cifti_volume(
  xifti,
  structural_img = "MNI",
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  structural_img_colors = gray(0:255/280),
  title = NULL,
  idx = NULL,
  plane = c("axial", "sagittal", "coronal"),
  convention = c("neurological", "radiological"),
  n_slices = 9,
  slices = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  widget = FALSE,
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  fname_sub = FALSE,
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  ypos.title = 0,
  xpos.title = 0,
  orientation_labels = TRUE,
  crop = TRUE,
  text_color = "white",
  bg = NULL,
  width = NULL,
  height = NULL,
  ...
)

viewCIfTI_volume(
  xifti,
  structural_img = "MNI",
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  structural_img_colors = gray(0:255/280),
  title = NULL,
  idx = NULL,
  plane = c("axial", "sagittal", "coronal"),
  convention = c("neurological", "radiological"),
  n_slices = 9,
  slices = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  widget = FALSE,
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  fname_sub = FALSE,
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  ypos.title = 0,
  xpos.title = 0,
  orientation_labels = TRUE,
  crop = TRUE,
  text_color = "white",
  bg = NULL,
  width = NULL,
  height = NULL,
  ...
)

viewcii_volume(
  xifti,
  structural_img = "MNI",
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  structural_img_colors = gray(0:255/280),
  title = NULL,
  idx = NULL,
  plane = c("axial", "sagittal", "coronal"),
  convention = c("neurological", "radiological"),
  n_slices = 9,
  slices = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  widget = FALSE,
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  fname_sub = FALSE,
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  ypos.title = 0,
  xpos.title = 0,
  orientation_labels = TRUE,
  crop = TRUE,
  text_color = "white",
  bg = NULL,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{structural_img}{The structural MRI image on which to overlay the
subcortical plot. Can be a file name, \code{"MNI"} (default) to use
the MNI T1-weighted template included in \code{ciftiTools}, or \code{NULL}
to use a blank image.}

\item{color_mode}{(Optional) \code{"sequential"}, \code{"qualitative"},
\code{"diverging"}, or \code{"auto"} (default). Auto mode will use the
qualitative color mode if the \code{"xifti"} object represents a .dlabel
CIFTI (intent 3007). Otherwise, it will use the diverging mode if the data
contains both positive and negative values, and the sequential mode if the
data contains >90\\% positive or >90\\% negative values. See
\code{\link{make_color_pal}} for more details.}

\item{zlim}{(Optional) Controls the mapping of values to each
color in \code{colors}. If the length is longer than
one, using -Inf will set the value to the data minimum, and Inf will set
the value to the data maximum. See \code{\link{make_color_pal}}
description for more details.}

\item{colors}{(Optional) \code{"ROY_BIG_BL"}, vector of colors to use,
the name of a ColorBrewer palette (see \code{RColorBrewer::brewer.pal.info}
and colorbrewer2.org), the name of a viridisLite palette, or a data.frame
with columns \code{"color"} and \code{"value"} (will override \code{zlim}).
If \code{NULL}
(default), will use the positive half of \code{"ROY_BIG_BL"} (sequential),
\code{"Set2"} (qualitative), or the full \code{"ROY_BIG_BL"} (diverging). An
exception to these defaults is if the \code{"xifti"} object represents a
.dlabel CIFTI (intent 3007), in which case the colors in the label table
will be used. See \code{\link{make_color_pal}} for more details.}

\item{structural_img_colors}{Colors to use for the background image. These
will be assigned in order from lowest to highest value with equal spacing
between the colors. (\code{color_mode}, \code{zlim} and \code{colors} have
no bearing on the background image colors.) This argument is used as
the \code{col.x} argument to \code{oro.nifti::overlay} directly. Default:
\code{gray(0:255/280)}. To use the \code{oro.nifti::overlay} default instead
set this argument to \code{gray(0:64/64)}.}

\item{title}{Optional title(s) for the plot(s). It will be printed at the top.

Default: \code{NULL} will not use any title if \code{length(idx)==1}.
Otherwise, it will use the time index (".dtseries") or name
(.dscalar or .dlabel) of each data column.

To use a custom title(s), use a length 1 character vector (same title for
each plot) or length \code{length(idx)} character vector (different title
for each plot). Set to \code{NULL} or an empty character to omit the title.

If the title is non-empty but does not appear, try lowering \code{cex.title}.}

\item{idx}{The time/column index of the data to display. \code{NULL} (default)
will display the first column.

If \code{widget}, only one index at a time may be displayed.

If \code{!widget} and the length of \code{idx} is greater than one, a new
plot will be created for each \code{idx}. These can be toggled between using
the arrows at the top of the display window if working interactively in
\code{RStudio}; or, these will be written to separate files if
\code{!isFALSE(fname)}.}

\item{plane}{The plane to display for the slices:
\code{"axial"} (default), \code{"sagittal"} or \code{"coronal"}.
Ignored if \code{widget}.}

\item{convention}{\code{"neurological"} (default) or \code{"radiological"}.
Neurological convention will display the left side of the brain on the left
side of axial and coronal images, and in the first few slices of a series of
sagittal images. Radiological convention will display the right side of the
brain on the left side of axial and coronal images, and in the first few
slices of a series of sagittal images.}

\item{n_slices}{The number of slices to display. Default: \code{9}.
The slices will be selected in a way that visualizes as much of the
subcortex as possible. Ignored if \code{widget}.}

\item{slices}{Which slices to display. If provided, this argument will
override \code{n_slices}. Should be a numeric vector with integer values
between one and the number of slices in \code{plane}. Ignored if \code{widget}.}

\item{together}{Only applies if saving image files (\code{!isFALSE(fname)}).
Use this argument to create and save a composite image which combines
multiple plots. \code{NULL} (default) will not combine any plots. Otherwise,
this argument should be a character vector with one or more of the
following entries:

\code{"leg"} to combine the color legend with each \code{"xifti"} data plot.
Overrides/ignores \code{legend_embed}.

\code{"idx"} to place all the plots for the different \code{"idx"} in a grid.
If the data is not qualitative, a shared color bar will be added to the bottom
of the composite. If the data is qualitative, a shared color legend will be
added to the bottom only if \code{"leg"} is in \code{together}.
For greater control see \code{view_comp} or \code{grid::arrangeGrob}.}

\item{together_ncol}{If \code{"idx" \%in\% together}, this determines the number
of columns to use in the array of subplots for different indices.
By default, the number of columns and rows will be determined such that they
are about equal.}

\item{together_title}{If a composite image is made based on \code{together},
use this argument to add a grand title to the composite image. Should be
a length-one character vector or \code{NULL} (default) to not add a grand title.}

\item{widget}{Create an interactive widget using \code{papayar}? Otherwise
display static 2D slices. Default: \code{FALSE}.

Note that the widget can only display one \code{idx} at a time.

Note: \code{papayar} has been removed
from CRAN so the widget is not available. If \code{papayar} returns to CRAN
the widget will be made available again.}

\item{fname, fname_suffix}{Save the plot(s) (and color legend if applicable)?

If \code{isFALSE(fname)} (default), no files will be written.

If \code{widget}, these arguments are ignored.

If neither of the cases above apply, a png image will be written for each
\code{idx}. If \code{isTRUE(fname)} the files will be named by the
data column names (underscores will replace spaces). Or, set \code{fname} to a
length 1 character vector to name files by this suffix followed by the
\code{fname_suffix}: either the data column names (\code{"names"}) or the
index value (\code{"idx"}). Or, set \code{fname} to a character vector with the same
length as \code{idx} to name the files exactly.}

\item{fname_sub}{Add "_sub" to the end of the names of the files being saved?
Default: \code{FALSE}. This is useful if cortical plots of the same data are being
saved too.}

\item{legend_fname}{Save the color legend? Since the legend is the same
for each \code{idx} only one legend is written even if \code{length(idx)>1}.
This argument can be \code{NULL} to not save the legend, an exact file
path, or a length-one character vector with "[fname]" in it, which will
name the legend based on \code{fname\[1\]}. For example, if \code{fname\[1\]}
is \code{"plots/my_cifti.png"} and \code{legend_fname} is \code{"\[fname\]_legend"}
(default), then the legend plot will be saved to \code{"plots/my_cifti_legend.png"}.}

\item{legend_ncol}{Number of columns in color legend. If
\code{NULL} (default), use 10 entries per row. Only applies if the color
legend is used (qualitative data).}

\item{legend_alllevels}{Show all label levels in the color legend? If
\code{FALSE} (default), just show the levels present in the data being
viewed. Only applies if the color legend is used (qualitative data).}

\item{legend_embed}{Should the colorbar be embedded in the plot?
It will be positioned at the bottom. Default: \code{TRUE}.
If \code{FALSE}, print/save it separately instead.

Only applies if the color bar is used (sequential or diverging data).
The color legend (qualitative data) cannot be embedded at the moment.}

\item{digits}{The number of digits for the colorbar legend ticks.
If \code{NULL} (default), let \code{\link{format}} decide.}

\item{scientific}{Use scientific notation? If \code{NA} (default), let
\code{\link{format}} decide.}

\item{cex.title}{Font size multiplier for the title. \code{NULL} (default)
will use \code{1.2} for titles less than 20 characters long, and smaller
sizes for increasingly longer titles. If saving a PNG and PDF file, the default
will also scale with \code{width} relative to the default value of \code{width}.}

\item{ypos.title, xpos.title}{The positioning of the title can be finicky,
especially when using an R Markdown document interactively in which case it
appears too high in the plot. Use these arguments to nudge the title up
or down (\code{ypos.title}) or left or right (\code{xpos.title}).}

\item{orientation_labels}{Show orientation labels at the top left and top
right of the plot? These will indicate the directions along the left-right
axis for each slice image. Default: \code{TRUE}. Ignored if \code{widget}.
The vertical positioning is controlled by \code{ypos.title}, and the font
size is controlled by \code{cex.title}.}

\item{crop}{Crop the slice subplots to the subcortical structures, instead of
showing the full anatomical image? Default: \code{TRUE}.
Ignored if \code{widget}.}

\item{text_color}{Color for text in title and colorbar legend. Default:
\code{"white"}. If \code{"white"}, will use black instead for the color}

\item{bg}{Background color. \code{NULL} will use \code{"black"}. Does not affect
the color legend or color bar if printed separately: those will always have
white backgrounds.}

\item{width, height}{The dimensions of the plot, in pixels. Only affects saved
images (if \code{!isFALSE(fname)}). If \code{NULL}, file dimensions will be
400 x 600 pixels for PNGs and 4 x 6 in. for PDFs.

Currently, there is no way to control the
dimensions of the plot if working interactively in RStudio or creating a knitted
R Markdown document. The default appears to be a wide aspect ratio.}

\item{...}{Additional arguments to pass to \code{papayar::papaya} or \code{oro.nifti::overlay}.
Note that for \code{oro.nifti::overlay} the following additional arguments
should not be provided since they are pre-determined inside this function
or by the arguments listed above:
\code{x}, \code{y}, \code{plane}, \code{col.y}, \code{col.x}, \code{zlim.y},
\code{oma}, \code{plot.type}, \code{bg}.}
}
\value{
If a png or pdf file(s) were written, the names of the files for
each index (and color legend if applicable) will be returned. Otherwise,
\code{NULL} is invisibly returned.
}
\description{
Visualize the subcortical data in a \code{"xifti"} using a series of 2D
slices (based on \code{\link[oro.nifti]{overlay}}) or an interactive widget
(based on \code{papayar::papaya}). Note: \code{papayar} has been removed
from CRAN so the widget is not available. If \code{papayar} returns to CRAN
the widget will be made available again.
}
\details{
Note that \code{color_mode}, \code{zlim}, and \code{colors} only affect the
color scale of the data values whereas \code{structural_img_colors} only
affects the color scale of the background image.

Currently, the color-related arguments only affect the 2D slice view. The
color limits and palette must be edited using the widget controls once it's
rendered.

Arguments concerning anatomical orientation assume that the subcortical data
is stored in the following way: first dimension is normal to the sagittal
plane, going left to right; second dimension is normal to the coronal plane,
going from the front of the head (anterior) to the back (posterior); third
dimension is normal to the axial plane, going from the top of the head
(superior) to the neck (inferior).

For non-interactive plots, if \code{n_slices > 1} and \code{convention="neurological"},
axial slices are ordered from the neck (inferior) to the top of the head
(superior), sagittal slices are ordered left to right, and coronal slices
are ordered back (posterior) to front (anterior). If
\code{convention="radiological"}, sagittal slices are instead ordered right
to left.
}
\seealso{
Other commonly-used functions: 
\code{\link{is.cifti}()},
\code{\link{read_cifti}()},
\code{\link{resample_cifti}()},
\code{\link{smooth_cifti}()},
\code{\link{view_xifti_surface}()},
\code{\link{write_cifti}()}
}
\concept{common}
