% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_submask.R
\name{move_to_submask}
\alias{move_to_submask}
\title{Move data locations to the subcortex mask}
\usage{
move_to_submask(xifti, values = c(NA, NaN), drop = FALSE)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{values}{Values to mask out. Default: \code{NA} and \code{NaN}. Data
locations in the subcortex that are one of these values (across all columns)
will be moved to the subcortex mask in the metadata.}

\item{drop}{Only used if the \code{"xifti"} has the dlabel intent. Drop the
key(s) in \code{values} from the label tables, for columns in which they no
longer exist? Default: \code{FALSE}.}
}
\value{
The \code{"xifti"} with re-organized data and subcortex masks
}
\description{
Move subcortex data locations with a specific value(s) to the subcortex mask.
}
\seealso{
move_from_submask

Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
