% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPlotFunctions.R
\name{plot_meanboxplot.circGLM}
\alias{plot_meanboxplot.circGLM}
\title{Plot mean comparison boxplot from circGLM objects}
\usage{
plot_meanboxplot.circGLM(m, xlab = "Mean direction")
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{xlab}{The label of the x-axis.}
}
\description{
If the main predictors of interest for the circGLM are categorical, it can be
insightful to plot the posteriors of the group means side-by-side, which this
function does. This is particularly useful for ANOVA or ANCOVA type designs.
}
\details{
If there are linear predictors in the model as well, the posteriors displayed
will correspond to the intercept parameter for each group.

Some caution is needed, as a regular linear boxplot is printed, which may not
always be meaningful for a circular variable.
}
\examples{
dat <- generateCircGLMData(nconpred = 0)
m   <- circGLM(th ~ ., dat)
plot_meancompare.circGLM(m)
}
\seealso{
\code{\link{plot_trace.circGLM}},
  \code{\link{plot_tracestack.circGLM}},
  \code{\link{plot_predict.circGLM}},
  \code{\link{plot_meancompare.circGLM}},
  \code{\link{plot.circGLM}}.
}
