% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkout-key.R
\name{checkout_key}
\alias{checkout_key}
\alias{create_checkout_key}
\alias{get_checkout_keys}
\alias{delete_checkout_key}
\alias{has_checkout_key}
\title{Interact with "Checkout Keys" on Circle CI}
\usage{
create_checkout_key(
  repo = github_info()$name,
  user = github_info()$owner$login,
  type = "user-key",
  api_version = "v2",
  vcs_type = "gh",
  quiet = FALSE
)

get_checkout_keys(
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v2"
)

delete_checkout_key(
  fingerprint = NULL,
  repo = github_info()$name,
  user = github_info()$owner$login,
  type = "user-key",
  api_version = "v2",
  vcs_type = "gh"
)

has_checkout_key(
  repo = github_info()$name,
  user = github_info()$owner$login,
  type = "github-user-key",
  vcs_type = "gh",
  preferred = TRUE
)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{type}{\verb{[character]}\cr
Type of key to add. Options are "user-key" and "deploy-key".}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{quiet}{\verb{[logical]}\cr
If \code{TRUE}, console output is suppressed.}

\item{fingerprint}{\verb{[character]}\cr
The fingerprint of the checkout key which should be deleted.}

\item{preferred}{\verb{[logical]}\cr
Checks whether the requested type is the "preferred" key.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Create, delete, query or check different types of checkout keys
for a specific Circle CI project.
Valid values for argument \code{type} are \code{"user-key"} or \code{"deploy-key"}.

A "Checkout Key" on Circle CI is a specific SSH key which is used to checkout
repositories into a Circle CI build and possible deploy changes to the
repository.
Circle CI subdivides "Checkout Keys" into "user-key" and "deploy-key".

Please see "Deployment" section in the "Getting Started" vignette for more
information.
}
\examples{
\dontrun{
# by default a "user-key" will be created which can also be used for build
# deployments
create_checkout_key()

# A "deploy-key" can only be used to checkout code from the repository into
# a Circle CI build
create_checkout_key(type = "deploy-key")
}
\dontrun{
get_checkout_keys()
}
\dontrun{
delete_checkout_key()
}
\dontrun{
has_checkout_key()
}
}
